#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fontconfig/fontconfig.h>
#include <fontconfig/fcfreetype.h>

#include "libfontconfig_const.h"
#include "libfreetype.h"

typedef struct {
	int nfont;
	int sfont;
	FcPattern **fonts;
	FcFontSet *native;
} FcFontSetProxy;

int handle_syscall(unsigned args[], emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case FCCHARSETFIRSTPAGE:
	{
		const FcCharSet *a = (void *) args[2];
		FcChar32 *target_map = (void *) tswap32(args[3]);
		FcChar32 map[FC_CHARSET_MAP_SIZE];
		FcChar32 *target_next = (void *) tswap32(args[4]);
		FcChar32 next;
		assign_result32(args[1], FcCharSetFirstPage(a, map, &next));
		memswap32(target_map, map, FC_CHARSET_MAP_SIZE);
		*target_next = tswap32(next);
		return 0;
	}
	case FCCHARSETNEXTPAGE:
	{
		const FcCharSet *a = (void *) args[2];
		FcChar32 *target_map = (void *) tswap32(args[3]);
		FcChar32 map[FC_CHARSET_MAP_SIZE];
		FcChar32 *target_next = (void *) tswap32(args[4]);
		FcChar32 next = tswap32(*target_next);
		assign_result32(args[1], FcCharSetNextPage(a, map, &next));
		memswap32(target_map, map, FC_CHARSET_MAP_SIZE);
		*target_next = tswap32(next);
		return 0;
	}
	case FCCONFIGSUBSTITUTE:
	{
		FcConfig *config = (void *) args[2];
		FcPattern *p = (void *) args[3];
		FcMatchKind kind = tswap32(args[4]);
		assign_result32(args[1], FcConfigSubstitute(config, p, kind));
		return 0;
	}
	case FCDEFAULTSUBSTITUTE:
	{
		FcPattern *pattern = (void *) args[1];
		FcDefaultSubstitute(pattern);
		return 0;
	}
	case FCFONTRENDERPREPARE:
	{
		FcConfig *config = (void *) args[2];
		FcPattern *pat = (void *) args[3];
		FcPattern *font = (void *) args[4];
		FcPattern **result = (void *) tswap32(args[1]);
		*result = FcFontRenderPrepare(config, pat, font);
		return 0;
	}
	case FCFONTSETDESTROY:
	{
		FcFontSetProxy *proxy = (void *) tswap32(args[1]);
		FcFontSet *s = proxy->native;
		FcFontSetDestroy(s);
		free(proxy);
		return 0;
	}
	case FCFONTSORT:
	{
		FcConfig *config = (void *) args[2];
		FcPattern *p = (void *) args[3];
		FcBool trim = tswap32(args[4]);
		FcCharSet **csp = (void *) tswap32(args[5]);
		FcResult *target_result = (void *) tswap32(args[6]);
		FcResult host_result;
		FcFontSet *set = FcFontSort(config, p, trim, csp, &host_result);
		FcFontSetProxy *proxy = malloc(sizeof(FcFontSetProxy));
		memswap32(proxy, set, size32of(FcFontSet));
		proxy->native = set;
		assign_result32(args[1], proxy);
		*target_result = tswap32(host_result);
		return 0;
	}
	case FCFREETYPECHARINDEX:
	{
		FT_Face face = get_face(args[2]);
		FcChar32 ucs4 = tswap32(args[3]);
		assign_result32(args[1], FcFreeTypeCharIndex(face, ucs4));
		return 0;
	}
	case FCPATTERNADD:
	{
		FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		unsigned *target_value = (void *) tswap32(args[4]);
		union {
			FcValue v;
			unsigned u[3];
		} value;
		value.v.type = tswap32(target_value[0]);
		switch (value.v.type) {
		case FcTypeInteger:
		case FcTypeBool:
			value.u[1] = tswap32(target_value[1]);
			break;
		case FcTypeDouble:
		{
#ifdef BSWAP_NEEDED
			static const int I1 = 2;
			static const int I2 = 1;
#else
			static const int I1 = 1;
			static const int I2 = 2;
#endif
			value.u[1] = tswap32(target_value[I1]);
			value.u[2] = tswap32(target_value[I2]);
			break;
		}
		default:
			printf("unhandled FcType %d\n", value.v.type);
		}
		FcBool append = tswap32(args[5]);
		assign_result32(args[1], FcPatternAdd(p, object, value.v,
			append));
		return 0;
	}
	case FCPATTERNADDSTRING:
	{
		FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		const FcChar8 *s = (void *) tswap32(args[4]);
		assign_result32(args[1], FcPatternAddString(p, object, s));
		return 0;
	}
	case FCPATTERNCREATE:
	{
		FcPattern **result = (void *) tswap32(args[1]);
		*result = FcPatternCreate();
		return 0;
	}
	case FCPATTERNDESTROY:
	{
		FcPattern *p = (void *) args[1];
		FcPatternDestroy(p);
		return 0;
	}
	case FCPATTERNGETBOOL:
	{
		const FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		FcBool *target_b = (void *) tswap32(args[5]);
		FcBool b;
		assign_result32(args[1], FcPatternGetBool(p, object, n, &b));
		*target_b = tswap32(b);
		return 0;
	}
	case FCPATTERNGETCHARSET:
	{
		const FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		FcCharSet **c = (void *) tswap32(args[5]);
		assign_result32(args[1], FcPatternGetCharSet(p, object, n, c));
		return 0;
	}
	case FCPATTERNGETDOUBLE:
	{
		const FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		double *target_d = (void *) tswap32(args[5]);
		double d;
		assign_result32(args[1], FcPatternGetDouble(p, object, n, &d));
		*target_d = swapd(d);
		return 0;
	}
	case FCPATTERNGETINTEGER:
	{
		const FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		int *target_i = (void *) tswap32(args[5]);
		int i;
		assign_result32(args[1], FcPatternGetInteger(p, object, n, &i));
		*target_i = tswap32(i);
		return 0;
	}
	case FCPATTERNGETMATRIX:
	{
		FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		FcMatrix **target_s = (void *) tswap32(args[5]);
		FcMatrix *s;
		FcResult host_result = FcPatternGetMatrix(p, object, n, &s);
		assign_result32(args[1], host_result);
		if (host_result != FcResultMatch)
			return 0;
		if (strcmp(FC_MATRIX, object))
			printf("property is not matrix, %s\n", object);
		FcMatrix *proxy_s;
		FcResult proxy_result = FcPatternGetMatrix(p, FC_MATRIX "proxy",
			n, &proxy_s);
		switch (proxy_result) {
		case FcResultNoMatch:
		{
			FcMatrix matrix_proxy;
			matrix_proxy.xx = swapd(s->xx);
			matrix_proxy.xy = swapd(s->xy);
			matrix_proxy.yx = swapd(s->yx);
			matrix_proxy.yy = swapd(s->yy);
			if (n != 0)
				printf("matrix is greater than 0\n");
			FcPatternAddMatrix(p, FC_MATRIX "proxy", &matrix_proxy);
			break;
		}
		default:
			printf("unhandled get matrix proxy result %d\n",
				proxy_result);
		}
		*target_s = tswap32(s);
		return 0;
	}
	case FCPATTERNGETSTRING:
	{
		const FcPattern *p = (void *) args[2];
		const char *object = (void *) tswap32(args[3]);
		int n = tswap32(args[4]);
		FcChar8 **target_s = (void *) tswap32(args[5]);
		FcChar8 *s;
		assign_result32(args[1], FcPatternGetString(p, object, n, &s));
		*target_s = tswap32(s);
		return 0;
	}
	case FCPATTERNHASH:
	{
//TODO: remove hash swap
		const FcPattern *p = (void *) args[2];
		assign_result32(args[1], FcPatternHash(p));
		return 0;
	}
	case FCPATTERNREFERENCE:
	{
		FcPattern *p = (void *) args[1];
		FcPatternReference(p);
		return 0;
	}
	default:
		fprintf(stderr, "Unimplemented function #%d.\n", function);
		return -1;
	}
}
