#include <err.h>
#include <stdlib.h>
#include <X11/extensions/xf86vmode.h>

#include "libX11.h"
#include "libXxf86vm_const.h"

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XF86VIDMODEGETALLMODELINES:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int screen = tswap32(args[3]);
		int *target_modecount = (void *) tswap32(args[4]);
		int modecount;
		XF86VidModeModeInfo ***modelinesPtr = (void *) tswap32(args[5]);
		XF86VidModeModeInfo **modelines;
		assign_result32(args[1], XF86VidModeGetAllModeLines(dpy, screen,
			&modecount, &modelines));
		*target_modecount = tswap32(modecount);
		*modelinesPtr = tswap32(modelines);
		int i;
		for (i = 0; i < modecount; i++) {
			modelines[i]->dotclock
				= tswap32(modelines[i]->dotclock);
			memswap16(&modelines[i]->hdisplay,
				&modelines[i]->hdisplay, 9);
			memswap32(&modelines[i]->flags, &modelines[i]->flags,
				3);
		}
		memswap32(modelines, modelines, modecount);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XF86VIDMODEGETGAMMARAMPSIZE:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int screen = tswap32(args[3]);
		int *target_size = (void *) tswap32(args[4]);
		int size;
		assign_result32(args[1], XF86VidModeGetGammaRampSize(dpy,
			screen, &size));
		*target_size = tswap32(size);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XF86VIDMODEGETMODELINE:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int screen = tswap32(args[3]);
		int *target_dotclock = (void *) tswap32(args[4]);
		int dotclock;
		XF86VidModeModeLine *target_modeline
			= (void *) tswap32(args[5]);
		XF86VidModeModeLine modeline;
		assign_result32(args[1], XF86VidModeGetModeLine(dpy, screen,
			&dotclock, &modeline));
		*target_dotclock = tswap32(dotclock);
		memswap16(target_modeline, &modeline, 9);
		memswap32(&target_modeline->flags, &modeline.flags, 3);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XF86VIDMODELOCKMODESWITCH:
	{
warnx("XF86VidModeLockModeSwitch called!");
		Display *dpy = get_display(args[2]);
		int screen = tswap32(args[3]);
		int lock = tswap32(args[4]);
		assign_result32(args[1], XF86VidModeLockModeSwitch(dpy, screen,
			lock));
		return 0;
	}
	case XF86VIDMODEQUERYEXTENSION:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_event_base = (void *) tswap32(args[3]);
		int event_base;
		int *target_error_base = (void *) tswap32(args[4]);
		int error_base;
		assign_result32(args[1], XF86VidModeQueryExtension(dpy,
			&event_base, &error_base));
		*target_event_base = tswap32(event_base);
		*target_error_base = tswap32(error_base);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XF86VIDMODEQUERYVERSION:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_majorVersion = (void *) tswap32(args[3]);
		int majorVersion;
		int *target_minorVersion = (void *) tswap32(args[4]);
		int minorVersion;
		assign_result32(args[1], XF86VidModeQueryVersion(dpy,
			&majorVersion, &minorVersion));
		*target_majorVersion = tswap32(majorVersion);
		*target_minorVersion = tswap32(minorVersion);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XF86VIDMODESETGAMMARAMP:
	{
warnx("XF86VidModeSetGammaRamp called!");
		Display *dpy = get_display(args[2]);
		int screen = tswap32(args[3]);
		int size = tswap32(args[4]);
		unsigned short *target_red = (void *) tswap32(args[5]);
		unsigned short *red = malloc(size * sizeof(unsigned short));
		memswap16(red, target_red, size);
		unsigned short *target_green = (void *) tswap32(args[6]);
		unsigned short *green = malloc(size * sizeof(unsigned short));
		memswap16(green, target_green, size);
		unsigned short *target_blue = (void *) tswap32(args[7]);
		unsigned short *blue = malloc(size * sizeof(unsigned short));
		memswap16(blue, target_blue, size);
		assign_result32(args[1], XF86VidModeSetGammaRamp(dpy, screen,
			size, red, green, blue));
		free(red);
		free(green);
		free(blue);
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.", function);
		return -1;
	}
}
