#include <err.h>
#include <X11/extensions/Xinerama.h>

#include "libX11.h"
#include "libXinerama_const.h"

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XINERAMAISACTIVE:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		assign_result32(args[1], XineramaIsActive(dpy));
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XINERAMAQUERYSCREENS:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_number = (void *) tswap32(args[3]);
		int number;
		XineramaScreenInfo *info = XineramaQueryScreens(dpy, &number);
		XineramaScreenInfo *swapp = info;
		int i = number;
		while (i--) {
			swapp->screen_number = tswap32(swapp->screen_number);
			memswap16(&swapp->x_org, &swapp->x_org, 4);
			swapp++;
		}
		assign_result32(args[1], info);
		*target_number = tswap32(number);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.\n", function);
		return -1;
	}
}
