#include <err.h>
#include <stdlib.h>
#include <X11/extensions/XInput.h>

#include "libX11.h"
#include "libXi_const.h"

typedef struct {
	XID end;
	XDeviceInfo *list;
} XDeviceInfoTail;

typedef struct {
	XID device_id;
	int num_classes;
	XInputClassInfo *classes;
	XDevice *native;
} XDeviceProxy;

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XFREEDEVICELIST:
	{
		XDeviceInfo *proxy = (void *) tswap32(args[1]);
		XDeviceInfo *info;
		for (info = proxy; info->id != (XID) -1; info++) ;
		XDeviceInfoTail *tail = (XDeviceInfoTail *) info;
		XDeviceInfo *list = tail->list;
		int ndevices = info - proxy;
		int i;
		for (i = 0; i < ndevices; i++) {
			XAnyClassPtr classinfo = list[i].inputclassinfo;
			int j;
			for (j = 0; j < list[i].num_classes; j++) {
				memswap32(classinfo, classinfo, 2);
				XID class = classinfo->class;
				int length = classinfo->length;
				switch (class) {
				case KeyClass:
				case ButtonClass:
					break;
				case ValuatorClass:
				{
					XValuatorInfo *v_info
						= (XValuatorInfo *) classinfo;
					v_info->axes = tswap32(v_info->axes);
					break;
				}
				default:
					warnx("unhandled input class %ld\n",
						class);
				}
				classinfo = (XAnyClassPtr) (((char *) classinfo)
					+ length);
			}
		}
		XFreeDeviceList(list);
		free(proxy);
		return 0;
	}
	case XLISTINPUTDEVICES:
	{
		DisplayProxy *display_proxy = (void *) tswap32(args[2]);
		Display *display = display_proxy->native;
		int *target_ndevices = (void *) tswap32(args[3]);
		int ndevices;
		XDeviceInfo *list = XListInputDevices(display, &ndevices);
		XDeviceInfo *proxy = malloc(ndevices * sizeof(XDeviceInfo)
			+ sizeof(XDeviceInfoTail));
		assign_result32(args[1], proxy);
		*target_ndevices = tswap32(ndevices);
		int i;
		for (i = 0; i < ndevices; i++) {
			XAnyClassPtr classinfo = list[i].inputclassinfo;
			int j;
			for (j = 0; j < list[i].num_classes; j++) {
				XID class = classinfo->class;
				int length = classinfo->length;
				memswap32(classinfo, classinfo, 2);
				switch (class) {
				case KeyClass:
				{
					XKeyInfo *k_info
						= (XKeyInfo *) classinfo;
					memswap16(&k_info->min_keycode,
						&k_info->min_keycode, 3);
					break;
				}
				case ButtonClass:
				{
					XButtonInfo *b_info
						= (XButtonInfo *) classinfo;
					b_info->num_buttons
						= tswap16(b_info->num_buttons);
					break;
				}
				case ValuatorClass:
				{
					XValuatorInfo *v_info
						= (XValuatorInfo *) classinfo;
					memswap32(v_info->axes, v_info->axes,
						v_info->num_axes
						* size32of(XAxisInfo));
					memswap32(&v_info->motion_buffer,
						&v_info->motion_buffer, 2);
					break;
				}
				default:
					warnx("unhandled input class %ld\n",
						class);
				}
				classinfo = (XAnyClassPtr) (((char *) classinfo)
					+ length);
			}
		}
		memswap32(proxy, list, ndevices * size32of(XDeviceInfo));
		XDeviceInfoTail *tail = (XDeviceInfoTail *) (proxy + ndevices);
		tail->end = -1;
		tail->list = list;
		display_proxy->request
			= tswap32(((_XPrivDisplay) display)->request);
		return 0;
	}
	case XOPENDEVICE:
	{
		DisplayProxy *display_proxy = (void *) tswap32(args[2]);
		Display *display = display_proxy->native;
		XID id = tswap32(args[3]);
		XDevice *device = XOpenDevice(display, id);
		XDeviceProxy *proxy = malloc(sizeof(XDeviceProxy));
		memswap32(proxy, device, size32of(XDevice));
		proxy->native = device;
		assign_result32(args[1], proxy);
		display_proxy->request
			= tswap32(((_XPrivDisplay) display)->request);
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.\n", function);
		return -1;
	}
}
