#include <err.h>
#include <stdlib.h>
#include <X11/extensions/Xfixes.h>

#include "libX11.h"
#include "libXfixes_const.h"

static void free_event_base(void *data) {
warnx("freeing event base");
	free(data);
}

static int swap_event(XEvent *dest, const XEvent *src, const XEvent *host,
	void *data) {
	int *event_base = data;
	int type = src == host ? src->type : tswap32(src->type);
	switch (type - *event_base) {
	case XFixesSelectionNotify:
		memswap32(dest, src, size32of(XFixesSelectionNotifyEvent));
		break;
	default:
		return 0;
	}
	return 1;
}

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XFIXESQUERYEXTENSION:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_event_basep = (void *) tswap32(args[3]);
		int event_basep;
		int *target_error_basep = (void *) tswap32(args[4]);
		int error_basep;
		assign_result32(args[1], XFixesQueryExtension(dpy, &event_basep,
			&error_basep));
		*target_event_basep = tswap32(event_basep);
		*target_error_basep = tswap32(error_basep);

		ProxyExtension *extension = proxy->target_ext;
		while (extension && extension->free_data != free_event_base)
			extension = extension->next;
		if (!extension) {
			extension = calloc(1, sizeof(ProxyExtension));
			extension->next = proxy->target_ext;
			extension->free_data = free_event_base;
			int *event_base = malloc(sizeof(int));
			*event_base = event_basep;
			extension->data = event_base;
			extension->swap_event = swap_event;
			proxy->target_ext = extension;
		}

		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XFIXESSELECTSELECTIONINPUT:
	{
		DisplayProxy *proxy = (void *) tswap32(args[1]);
		Display *dpy = proxy->native;
		Window win = tswap32(args[2]);
		Atom selection = tswap32(args[3]);
		unsigned long eventMask = tswap32(args[4]);
		XFixesSelectSelectionInput(dpy, win, selection, eventMask);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.\n", function);
		return -1;
	}
}
