#include <err.h>
#include <X11/Xcursor/Xcursor.h>

#include "libX11.h"
#include "libXcursor_const.h"

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XCURSORGETDEFAULTSIZE:
	{
		Display *dpy = get_display(args[2]);
		assign_result32(args[1], XcursorGetDefaultSize(dpy));
		return 0;
	}
	case XCURSORGETTHEME:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		assign_result32(args[1], XcursorGetTheme(dpy));
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XCURSORSETDEFAULTSIZE: {
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int size = tswap32(args[3]);
		assign_result32(args[1], XcursorSetDefaultSize(dpy, size));
		return 0;
	}
	case XCURSORSETTHEME: {
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		const char *theme = (void *) tswap32(args[3]);
		assign_result32(args[1], XcursorSetTheme(dpy, theme));
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.\n", function);
		return -1;
	}
}
