#include <err.h>
#include <X11/extensions/Xcomposite.h>

#include "libX11.h"
#include "libXcomposite_const.h"

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case XCOMPOSITEQUERYEXTENSION:
	{
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_event_basep = (void *) tswap32(args[3]);
		int event_basep;
		int *target_error_basep = (void *) tswap32(args[4]);
		int error_basep;
		assign_result32(args[1], XCompositeQueryExtension(dpy,
			&event_basep, &error_basep));
		*target_event_basep = tswap32(event_basep);
		*target_error_basep = tswap32(error_basep);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	case XCOMPOSITEQUERYVERSION: {
		DisplayProxy *proxy = (void *) tswap32(args[2]);
		Display *dpy = proxy->native;
		int *target_major_version_return = (void *) tswap32(args[3]);
		int major_version_return;
		int *target_minor_version_return = (void *) tswap32(args[4]);
		int minor_version_return;
		assign_result32(args[1], XCompositeQueryVersion(dpy,
			&major_version_return, &minor_version_return));
		*target_major_version_return = tswap32(major_version_return);
		*target_minor_version_return = tswap32(minor_version_return);
		proxy->request = tswap32(((_XPrivDisplay) dpy)->request);
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.\n", function);
		return -1;
	}
}
