#ifndef _QEMU_HANDLER_LIBX11_H
#define _QEMU_HANDLER_LIBX11_H

#include <emu-stub/handler.h>
#include <X11/Xlib.h>

struct _DisplayProxy;

typedef struct {
	Visual *native;
	VisualID visualid;
	int class;
	unsigned long red_mask;
	unsigned long green_mask;
	unsigned long blue_mask;
	int bits_per_rgb;
	int map_entries;
} VisualProxy;

typedef struct {
	Screen *native;
	struct _DisplayProxy *display;
	Window root;
	int width;
	int height;
	char pad0[8];
	int ndepths;
	Depth *depths;
	int root_depth;
	VisualProxy *root_visual;
	char pad1[4];
	Colormap cmap;
	unsigned long white_pixel;
	unsigned long black_pixel;
	char pad2[20];
} ScreenProxy;

typedef struct _DisplayProxy {
	char pad0[8];
	int fd;
	char pad1[12];
	char *vendor;
	char pad2[20];
	int byte_order;
	char pad3[8];
	int bitmap_bit_order;
	char pad4[12];
	int release;
	char pad5[12];
	unsigned long last_request_read;
	unsigned long request;
	char *last_req;
	char pad6[4];
	char *bufptr;
	char *bufmax;
	char pad7[8];
	int (*synchandler)(struct _XDisplay *);
	char *display_name;
	int default_screen;
	int nscreens;
	ScreenProxy *screens;
	char pad8[1080];
	struct _XInternalAsync *async_handlers;
	char pad9[4];
	struct _XLockPtrs *lock_fns;
	Display *native;
	int extension;
	struct _XExtenProxy *ext_proxies;
	Bool async_handler_set;
	struct sent_request *sent_requests;
	int xkb_event_base;
	struct ProxyExtension *target_ext;
} DisplayProxy;

typedef struct ProxyExtension {
	struct ProxyExtension *next;
	void (*free_data)(void *);
	void *data;
	int (*swap_event)(XEvent *, const XEvent *, const XEvent *, void *);
} ProxyExtension;

typedef struct {
	int width;
	int height;
	int xoffset;
	int format;
	char *data;
	int byte_order;
	int bitmap_unit;
	int bitmap_bit_order;
	int bitmap_pad;
	int depth;
	int bytes_per_line;
	int bits_per_pixel;
	unsigned long red_mask;
	unsigned long green_mask;
	unsigned long blue_mask;
	XPointer obdata;
	struct funcs f;
	XImage *native;
	int initial_sync;
} XImageProxy;

static inline Display *get_display(unsigned arg) {
	DisplayProxy *proxy = (void *) tswap32(arg);
	return proxy->native;
}

static inline Visual *get_visual(unsigned arg) {
	if (!arg)
		return NULL;
	VisualProxy *proxy = (void *) tswap32(arg);
	return proxy->native;
}

#endif
